const { app, BrowserWindow } = require("electron");
const url = require("url");
const path = require("path");

let mainWindow;

function createWindow() {
  mainWindow = new BrowserWindow({
    width: 1024,
    height: 768,
    fullscreen: true,
    maximize:true,
    show: true,
    autoHideMenuBar:true,
    webPreferences: {
      nodeIntegration: true,
      // preload: path.join(__dirname, 'preload.js')

    },
  });

  mainWindow.loadURL(
    url.format({
      pathname: path.join(__dirname, `../dist/vipos-desktop/browser/index.html`),
      protocol: "file:",
      slashes: true,
    })
  );

  //img.icons8.com/?size=256&id=ipBLdOAQ6sRn&format=png
  // Open the DevTools.
  // https: mainWindow.webContents.openDevTools();

  mainWindow.on("closed", function () {
    mainWindow = null;
  });
}

app.on("ready", createWindow);

app.on("window-all-closed", function () {
  if (process.platform !== "darwin") app.quit();
});

app.on("activate", function () {
  if (mainWindow === null) createWindow();
});
